using System;
using System.Collections.Generic; // Przestrze nazw klas oglnych

namespace Enumerable
{
	public class ListBoxTest : IEnumerable<String>
	{
		private string[] strings;
		private int ctr = 0;
		// Klasy, po ktrych mona wylicza, zwracaj licznik
		public IEnumerator<string> GetEnumerator()
		{
			foreach (string s in strings)
			{
				yield return s;
			}
		}

		// Wymagana w celu implementacji interfejsu IEnumerable 
		System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator()
		{
			throw new NotImplementedException();
		}

		// Inicjowanie listy przy uyciu acuchw znakw 
		public ListBoxTest(params string[] initialStrings)
		{
			// Przydzielanie pamici dla acuchw znakw 
			strings = new String[256];

			// Kopiuje acuchy znakw przekazane do konstruktora 
			foreach (string s in initialStrings)
			{
				strings[ctr++] = s;
			}
		}

		// Dodaje pojedynczy acuch znakw na koniec listy
		public void Add(string theString)
		{
			strings[ctr] = theString;
			ctr++;
		}

		// Umoliwia dostp taki jak do tablicy 
		public string this[int index]
		{
			get
			{
				if (index < 0 || index >= strings.Length)
				{
					// Obsuga niepoprawnych indeksw
				}
				return strings[index];
			}
			set
			{
				strings[index] = value;
			}
		}

		// Informuje o liczbie przechowywanych acuchw znakw 
		public int GetNumEntries()
		{
			return ctr;
		}

	}

	public class Tester
	{
		static void Main()
		{
			// Tworzenie i inicjowanie nowej listy
			ListBoxTest lbt =
			   new ListBoxTest("Witaj", "wiecie");

			// Dodawanie kilku acuchw znakw 
			lbt.Add("Proust");
			lbt.Add("Faulkner");
			lbt.Add("Mann");
			lbt.Add("Hugo");

			// Sprawdzanie dostpu
			string subst = "Wszechwiecie";
			lbt[1] = subst;

			// Dostp do wszystkich acuchw znakw 
			foreach (string s in lbt)
			{
				if (s == null)
				{
					break;
				}

				Console.WriteLine("Warto: {0}", s);
			}
		}
	}
}
